USE [NWIC_PanelMgmt]
GO

/****** Object:  StoredProcedure [app].[NVCC_usp_GetConsults]    Script Date: 1/12/2016 4:58:44 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


ALTER PROCEDURE [app].[NVCC_usp_GetConsults]
	-- Add the parameters for the stored procedure here
	@pid bigint -- this is the patientsid

AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Jerry Kohler (Original script by Dr. Charles Demosthenes)
--Object/SP Name		: NVCC_usp_GetConsults
--SERVER				: DNS.URL        
--Data Base				: NWIC_PanelMgmt
--Schema				: app
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 01-12-2016
--Last Changed          : 01-12-2016  
--Last Changed By		: Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Removed station parameter in order to expand the search
--                        for a patient's consults from a single station to any
--                        station a patient is associated with.
--
--Purpose               : Retrieve a patient's consults from within the last 180
--                        days for inclusion into NVCC documentation.
--=================================================================================

BEGIN
   -- SET NOCOUNT ON added to prevent extra result sets from
   -- interfering with SELECT statements.
   SET NOCOUNT ON;

   SELECT
      c.Sta3n
     ,App.udf_StationName (c.Sta3n) AS StationName
     ,c.ToRequestServiceName
     ,cast(c.RequestDateTime as date) AS RequestDate
     ,c.CPRSStatus
     ,c.CPRSOrderSID
     ,c.Consultsid
   	 ,c.ConsultIEN
     ,c.PatientSID
     ,c.ToRequestServiceSID
     ,c.RequestType
   	 ,c.OrderStatusSID
     ,c.RecentActivityTypeSID
     ,c.RecentActivityType
   	 ,c.SendingStaffSID
     ,c.Urgency
     ,c.InpatOutpat
   	 ,iif(c.ProvisionalDiagnosis is null, ' ', c.ProvisionalDiagnosis) AS ProvDx
   	 ,iif(c.ProvisionalDiagnosisCode is null, ' ', c.ProvisionalDiagnosisCode) AS ProvDxCode
   	 ,c.TIUDocumentSID
     ,c.EarliestDate
     ,r.ConsultReason
	 ,l.LocationName as FromService
	 , st.StaffName as RequestingProvider
   FROM RDWWork.Con.Consult c
   JOIN RDWWork.SPatient.SConsultReason r ON r.ConsultSID = c.ConsultSID
   join RDWWork.dim.Location l
	on l.LocationSID=c.FromLocationSID
	join RDWWork.SStaff.SStaff st
	on st.StaffSid=c.SendingStaffSID
   WHERE c.ToRequestServiceName not like 'NON-FORM%' 
   	 AND c.CPRSStatus not in ('DISCONTINUED','CANCELLED','COMPLETE') 
   	 AND c.patientsid in (select PTSid from [App].[udf_AllPatientsSIDs](@pid))
     AND c.RequestDateTime >= CAST(dateadd(dd, -180, getdate()) AS DATE)
   ORDER BY c.requestdatetime;
END

GO
